﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class GetStationCodesStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            using (var _service = new Xrm(state.OrganizationServiceProxy))
            {
                if (!state.IsHomeMobile)
                {
                    var patSitecode = state.GetConsultsRequest.PatLoginSiteCode;
                    var patSite = _service.mcs_siteSet.FirstOrDefault(s => s.Id == new Guid(patSitecode));
                    var patFacility = _service.mcs_facilitySet.FirstOrDefault(f => f.Id == patSite.mcs_FacilityId.Id);
                    state.PatientStationCode = patFacility.mcs_StationNumber;
                }
                if (!state.IsStoreForward && state.GetConsultsRequest.ProLoginSiteCode != state.GetConsultsRequest.PatLoginSiteCode)
                {
                    var proSitecode = state.GetConsultsRequest.ProLoginSiteCode;
                    var proSite = _service.mcs_siteSet.FirstOrDefault(s => s.Id == new Guid(proSitecode));
                    var proFacility = _service.mcs_facilitySet.FirstOrDefault(f => f.Id == proSite.mcs_FacilityId.Id);
                    state.ProviderStationCode = proFacility.mcs_StationNumber;
                }
            }
        }
    }
}
